// Startup function
$(function ()
{
    $.fn.popover.Constructor.Default.whiteList.table = [];
    $.fn.popover.Constructor.Default.whiteList.tr = [];
    $.fn.popover.Constructor.Default.whiteList.td = [];
    $.fn.popover.Constructor.Default.whiteList.th = [];
    $.fn.popover.Constructor.Default.whiteList.div = [];
    $.fn.popover.Constructor.Default.whiteList.tbody = [];
    $.fn.popover.Constructor.Default.whiteList.thead = [];

    $('[data-toggle="tooltip"]').tooltip();

    loadCurrentProfileDrivers();
    getStatus();

    $("#drivers_list").change(function ()
    {
        var name = $("#profiles option:selected").text();
        saveProfileDrivers(name, true);
    });

    $("#remote_drivers").change(function ()
    {
        var name = $("#profiles option:selected").text();
        saveProfileDrivers(name, true);
    });

    // Restart
    $('#restart_sm').confirmation({
        onConfirm: function ()
        {
            $.ajax({ type: 'POST', url: '/api/system/reboot' });
            $("#server_notify").html("<p class='alert alert-success'>StellarMate is restarting...</p>");
        }
    });

    // Shutdown
    $('#shutdown_sm').confirmation({
        onConfirm: function ()
        {
            $.ajax({ type: 'POST', url: '/api/system/shutdown' });
            $("#server_notify").html("<p class='alert alert-success'>StellarMate is shutting down...</p>");
        }
    });

    getSMInfo();

    // Detect available KStars flatpaks for driver sources
    detectFlatpaks();

    $("#vnc_sm").attr("onClick", "location.href='http://" + window.location.hostname + ":6080/vnc.html'");
});

function getSMInfo()
{
    var hostname = "Uknown";
    $.getJSON("/api/info/hostname", function (jsonResponse)
    {
        if (jsonResponse)
        {
            hostname = jsonResponse.hostname;
        }
    });

    var model = "Unknown";
    $.getJSON("/api/info/model", function (jsonResponse)
    {
        if (jsonResponse)
        {
            model = jsonResponse.model;
        }
    });

    var version = "Unknown";
    $.getJSON("/api/info/version", function (jsonResponse)
    {
        if (jsonResponse)
        {
            version = jsonResponse.version;
        }
    });

    let interfaces = [];

    $.getJSON("/api/info/interfaces", function (jsonResponse)
    {

        if (jsonResponse instanceof Array) 
        {
            interfaces = jsonResponse;
        }
        else
        {
            interfaces = jsonResponse.interfaces;
        }

    });

    $('#sm-info-button').popover(
        {
            trigger: 'click',
            placement: 'right',
            html: true,
            title: "StellarMate Info",
            content: function ()
            {
                let listHTML = "<table class='table table-striped'><tbody>";
                listHTML += "<tr><td><b>Name</b></td><td>" + hostname + "</td></tr>";
                listHTML += "<tr><td><b>Model</b></td><td>" + model + "</td></tr>";
                listHTML += "<tr><td><b>Version</b></td><td>" + version + "</td></tr>";
                listHTML += "</tbody></table>";

                listHTML += "<table class='table table-striped'><thead class='thead-light'><tr><th>Interface</th><th>IP Address</th></tr></thead>";
                listHTML += "<tbody>";
                for (const iface of interfaces)
                // //interfaces.forEach( function(iface)
                {
                    listHTML += "<tr><td>" + iface.interface + "</td><td>" + iface.ip + "</td></tr>";
                }
                listHTML += "</tbody></table>";

                return listHTML;
            }
        });
}


function saveProfile()
{
    var options = profiles.options;
    var name = options[options.selectedIndex].value;
    // Remove any extra spaces
    name = name.trim();

    var url = "/api/profiles/" + name;

    //console.log(url)

    $.ajax({
        type: 'POST',
        url: encodeURI(url),
        success: function ()
        {
            //console.log("add new a profile " + name);
            saveProfileDrivers(name);
        },
        error: function ()
        {
            alert('error add new  profile failed');
        }
    });
}

function saveProfileInfo()
{
    var options = profiles.options;
    var name = options[options.selectedIndex].value;
    console.log(name);
    var port = parseInt($("#profile_port").val());
    console.log(port);
    var autostart = ($('#profile_auto_start').is(':checked')) ? 1 : 0;
    var autoconnect = ($('#profile_auto_connect').is(':checked')) ? 1 : 0;
    var driver_source = $("#driver_source").val();
    //console.log(autostart);
    //var url     =  "/api/profiles/" + name + "/" + port + "/" + autostart;
    var url = "/api/profiles/" + name;

    var profileInfo = {
        "port": port,
        "autostart": autostart,
        "autoconnect": autoconnect,
        "driver_source": driver_source
    };
    profileInfo = JSON.stringify(profileInfo);
    console.log("Profile info " + profileInfo);

    console.log(url);

    $.ajax({
        type: 'PUT',
        url: encodeURI(url),
        data: profileInfo,
        contentType: "application/json; charset=utf-8",
        success: function ()
        {
            console.log("Profile " + name + " info is updated");
        },
        error: function ()
        {
            alert('error update profile info failed');
        }
    });
}

function saveProfileDrivers(profile, silent)
{

    if (typeof (silent) === 'undefined') silent = false;

    var url = "/api/profiles/" + profile + "/drivers";
    var drivers = [];

    $("#drivers_list :selected").each(function (i, sel)
    {
        drivers.push({
            "label": $(sel).text()
        });
    });

    // Check for remote drivers
    var remote = $("#remote_drivers").val();
    if (remote)
    {
        drivers.push({
            "remote": remote
        });
        console.log({
            "remote": remote
        });
    }

    drivers = JSON.stringify(drivers);

    //console.log("my json string is " + drivers);

    $.ajax({
        type: 'POST',
        url: encodeURI(url),
        data: drivers,
        contentType: "application/json; charset=utf-8",
        success: function ()
        {
            //console.log("Drivers added successfully to profile");
            if (silent === false)
                $("#notify_message").html('<br/><div class="alert alert-success"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Profile ' + profile + ' saved.</div>');
        },
        error: function ()
        {
            alert('error failed to add drivers to profile');
        }
    });
}

function loadCurrentProfileDrivers()
{
    clearDriverSelection();

    var name = $("#profiles option:selected").text();
    var url = "/api/profiles/" + name + "/labels";

    $.getJSON(url, function (drivers)
    {
        $.each(drivers, function (i, driver)
        {
            var label = driver.label;
            //console.log("Driver label is " + label);
            var selector = "#drivers_list [value='" + label + "']";
            $(selector).prop('selected', true);
        });

        $("#drivers_list").selectpicker('refresh');
    });

    url = encodeURI("/api/profiles/" + name + "/remote");

    $.getJSON(url, function (data)
    {
        if (data && data.drivers !== undefined)
        {
            $("#remote_drivers").val(data.drivers);
        }
        else
        {
            $("#remote_drivers").val("");
        }
    });

    loadProfileData();

}

function loadProfileData()
{
    var name = $("#profiles option:selected").text();
    var url = encodeURI("/api/profiles/" + name);

    $.getJSON(url, function (info)
    {
        if (info.autostart == 1)
            $("#profile_auto_start").prop("checked", true);
        else
            $("#profile_auto_start").prop("checked", false);

        if (info.autoconnect == 1)
            $("#profile_auto_connect").prop("checked", true);
        else
            $("#profile_auto_connect").prop("checked", false);

        $("#profile_port").val(info.port);

        // Set driver source
        if (info.driver_source)
        {
            $("#driver_source").val(info.driver_source);
        } else
        {
            $("#driver_source").val("system");
        }

    });
}

function clearDriverSelection()
{
    $("#drivers_list option").prop('selected', false);
    $("#drivers_list").selectpicker('refresh');
    // Uncheck Auto Start
    $("#profile_auto").prop("checked", false);
    $("#profile_port").val(7624);
}

function addNewProfile()
{
    var profile_name = $("#new_profile_name").val();
    if (profile_name)
    {
        //console.log("profile is " + profile_name);
        $("#profiles").append("<option id='" + profile_name + "' selected>" + profile_name + "</option>");

        clearDriverSelection();

        $("#notify_message").html('<br/><div class="alert alert-success"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Profile ' + profile_name + ' created. Select the profile drivers and then save the profile.</div>');
    }
}

function removeProfile()
{
    //console.log("in delete profile");
    var name = $("#profiles option:selected").text();
    var url = "/api/profiles/" + name;

    console.log(url);

    if ($("#profiles option").size() == 1)
    {
        $("#notify_message").html('<br/><div class="alert alert-success"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Cannot delete default profile.</div>');
        return;
    }

    $.ajax({
        type: 'DELETE',
        url: encodeURI(url),
        success: function ()
        {
            //console.log("delete profile " + name);
            $("#profiles option:selected").remove();
            $("#profiles").selectpicker('refresh');
            loadCurrentProfileDrivers();

            $("#notify_message").html('<br/><div class="alert alert-success"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Profile ' + name + ' deleted.</div>');
        },
        error: function ()
        {
            alert('error delete profile failed');
        }
    });
}

function toggleServer()
{
    var status = $.trim($("#server_command").text());

    if (status == "Start")
    {
        var profile = $("#profiles option:selected").text();
        var url = "/api/server/start/" + profile;

        // Show loading state
        $("#server_notify").html("<p class='alert alert-info'><span class='fas fa-spinner fa-spin'></span> Starting INDI server...</p>");
        $("#server_command").prop('disabled', true);

        $.ajax({
            type: 'POST',
            url: encodeURI(url),
            success: function ()
            {
                //console.log("INDI Server started!");
                // Poll for server status with timeout
                pollServerStatus(0);
            },
            error: function ()
            {
                alert('Failed to start INDI server.');
                $("#server_command").prop('disabled', false);
            }
        });
    } else
    {
        $.ajax({
            type: 'POST',
            url: "/api/server/stop",
            success: function ()
            {
                //console.log("INDI Server stopped!");
                getStatus();
            },
            error: function ()
            {
                alert('Failed to stop INDI server.');
            }
        });
    }
}

function pollServerStatus(attempts)
{
    if (attempts >= 10)
    {
        // Timeout after 10 attempts (5 seconds)
        $("#server_notify").html("<p class='alert alert-warning'>Server start timeout. Please check manually.</p>");
        $("#server_command").prop('disabled', false);
        getStatus();
        return;
    }

    $.getJSON("/api/server/status", function (data)
    {
        if (data[0].status == "True")
        {
            // Server is running, get active drivers
            getActiveDrivers();
            $("#server_command").prop('disabled', false);
        }
        else
        {
            // Server not yet running, poll again
            setTimeout(function ()
            {
                pollServerStatus(attempts + 1);
            }, 500); // Poll every 500ms
        }
    }).fail(function ()
    {
        // Error checking status, try again
        setTimeout(function ()
        {
            pollServerStatus(attempts + 1);
        }, 500);
    });
}

function getStatus()
{
    $.getJSON("/api/server/status", function (data)
    {
        if (data[0].status == "True")
            getActiveDrivers();
        else
        {
            $("#server_command").html("<span class='fas fa-play fa-fw' aria-hidden='true'></span> Start");
            $("#server_notify").html("<p class='alert alert-info'>Server is Offline.</p>");
        }

    });
}

function getActiveDrivers()
{
    $.getJSON("/api/server/drivers", function (data)
    {
        $("#server_command").html("<span class='fas fa-stop fa-fw' aria-hidden='true'></span> Stop");
        var msg = "<p class='alert alert-info'>Server is Online.<ul  class=\"list-unstyled\">";
        var counter = 0;
        $.each(data, function (i, field)
        {
            msg += "<li>" + "<button class=\"btn btn-xs\" " +
                "onCLick=\"restartDriver('" + field.label + "')\" data-toggle=\"tooltip\" " +
                "title=\"Restart Driver\">" +
                "<span class=\"fa fa-redo fa-fw\" aria-hidden=\"true\"></span></button> " +
                field.label + "</li>";
            counter++;
        });

        msg += "</ul></p>";

        $("#server_notify").html(msg);

        if (counter < $("#drivers_list :selected").size())
        {
            $("#notify_message").html('<br/><div class="alert alert-success"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Not all profile drivers are running. Make sure all devices are powered and connected.</div>');
            return;
        }
    });

}

function restartDriver(label)
{
    $.ajax({
        type: 'POST',
        url: "/api/drivers/restart/" + label,
        success: function ()
        {
            getStatus();
            $("#notify_message").html('<br/><div class="alert alert-success"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Restarting driver "' + label + '" succeeded.</div>');
        },
        error: function ()
        {
            alert('Restarting driver "' + label + '" failed!');
        }
    });
}

// Detect available KStars flatpaks for driver sources
function detectFlatpaks()
{
    $.getJSON("/api/flatpak/detect", function (data)
    {
        if (!data.available)
        {
            console.log('Flatpak not available on this system');
            return;
        }

        // Enable and update stable option
        if (data.stable.installed)
        {
            $("#flatpak-stable-option").prop('disabled', false);
            $("#stable-version").text('v' + data.stable.version);
        }
        else
        {
            $("#stable-version").text('not installed');
        }

        // Enable and update master option
        if (data.master.installed)
        {
            $("#flatpak-master-option").prop('disabled', false);
            $("#master-version").text('v' + data.master.version);
        }
        else
        {
            $("#master-version").text('not installed');
        }
    }).fail(function ()
    {
        console.error('Failed to detect flatpaks');
        $("#stable-version").text('detection failed');
        $("#master-version").text('detection failed');
    });
}
