#!/usr/bin/env python3
import tkinter as tk
import subprocess
from tkinter import messagebox

mw = tk.Tk()
mw.title('StellarMate Reset')
mw.geometry('200x50')

def factory():
    if messagebox.askyesno('Verify', 'Are you sure you want to factory reset? This operation is irreversible!', icon=messagebox.WARNING):
        subprocess.Popen(['/usr/bin/pkexec', 'sh', '-c', '/etc/stellarmate/reset-factory.sh'])
        messagebox.showinfo('Success', 'Factory reset complete. Restart StellarMate now.')
    else:
        messagebox.showinfo('No', 'Factory reset cancelled.')

def wifi():
    if messagebox.askyesno('Verify', 'Are you sure you want to reset WiFi?', icon=messagebox.WARNING):
        subprocess.Popen(['/usr/bin/pkexec', 'sh', '-c', '/etc/stellarmate/reset-wifi.sh'])
        messagebox.showinfo('Success', 'WiFi is reset. Restart StellarMate now.')
    else:
        messagebox.showinfo('No', 'Reset WiFi cancelled.')

tk.Button(text='WiFi Reset', command=wifi).pack(fill=tk.X)
tk.Button(text='Factory Reset', command=factory).pack(fill=tk.X)
mw.mainloop()
