#!/bin/bash

# Generate random unit hostname
# and then put it in respective files. This is done on FIRST BOOT UP only by a systemd service file

UHOST=stellarmate_$(date | md5sum | cut -c 1-6)

echo "Unique Hostname is" $UHOST

# We need to update 4 files
# /etc/hosts
# /etc/hostname
# /etc/netconnectd.yaml
# /etc/netconnectd.conf.d/hostapd/stellarmate.conf
sed -i "s/stellarmate/$UHOST/g" /etc/hosts /etc/netconnectd.conf.d/hostapd/stellarmate.conf
sed -i "s/ssid: stellarmate/ssid: $UHOST/g" /etc/netconnectd.yaml
# Change hostname
echo $UHOST > /etc/hostname

echo "Unique hostname generated"
