#!/bin/bash

device="$(hcitool dev | sed -n 's/\s*\(hci.\).*/\1/p')"
address="$(hcitool dev | sed -n 's/\s*hci.\s*\(.*\)/\1/p')"

if [[ $address ]]
then
rfcomm release $device
rfcomm bind $device $address 1
echo "Binding $device to $address on channel 1..."
else
echo "Could not find any bluetooth devices to bind with."
fi

