#!/bin/bash

# Source common reset functions
source /etc/stellarmate/reset-factory-common.sh

# Perform common reset operations with stellarmate hostname
perform_common_reset "stellarmate"

cp /etc/stellarmate/kstars/config/* /home/stellarmate/.config
cp /etc/stellarmate/kstars/catalogs/* /home/stellarmate/.local/share/kstars

# SM-110 specific operations
# Set plymouth theme
plymouth-set-default-theme stellarmate-logo

# Reset boot to default settings
echo "Resetting boot to default..."
arch=$(uname -m)
if [ "$arch" == "armv7l" ]
then
  cp /etc/stellarmate/boot/32/* /boot/
elif [ "$arch" == "aarch64" ]
then
  cp /etc/stellarmate/boot/64/* /boot/
fi

# Clean up Raspberry Pi specific files
rm -f /boot/.firmware_revision || true
rm -rf /boot.bak || true
rm -rf /etc/stellarmate/8gb || true

# Clean apt cache and remove RPi specific packages
apt-get -y purge rpi.gpio-common modemmanager

# Enable filesystem resize service
echo "Enabling resize file system service..."
systemctl enable resize-fs.service

echo "Reset complete. StellarMate must be restarted now."
