#!/bin/bash

# Function to perform common reset operations
function perform_common_reset() {
    local hostname=${1:-stellarmate}

    local OS_TYPE="unknown"
    if [ -f /etc/os-release ]; then
        . /etc/os-release
        if [[ "$ID" == "arch" ]] || [[ "$ID_LIKE" == *"arch"* ]]; then
            OS_TYPE="arch"
        else
            OS_TYPE="debian_ubuntu"
        fi
    fi

    # Change hostname
    /etc/stellarmate/change-hostname.sh "$hostname"

    # Reset network interface
    /etc/stellarmate/reset-wifi.sh

    # Reset GPS settings
    sed -i 's|DEVICES=.*|DEVICES="/dev/gps"|' /etc/default/gpsd

    # Cleanup user and system directories
    rm -rf /home/stellarmate/.indi/* || true
    rm -rf /home/stellarmate/.cache/* || true
    rm -rf /home/stellarmate/.nano/* || true
    mkdir /home/stellarmate/.indi/logs
    rm -rf /home/stellarmate/.local/share/kstars/* || true
    mkdir /home/stellarmate/.local/share/kstars/logs
    rm -rf /home/stellarmate/PHD2 || true
    rm -rf /home/stellarmate/phd* || true
    rm -rf /home/stellarmate/.phd2 || true
    # Distribution-specific cleanup for package manager files
    if [ "$OS_TYPE" == "debian_ubuntu" ]; then
        rm -f /etc/apt/*.save || true
        rm -f /etc/apt/sources.list.d/*.save || true
    fi
    rm -f /etc/resolvconf/resolv.conf.d/original
    rm -f /run/*/*pid || true
    rm -f /run/*pid || true
    rm -f /run/cups/cups.sock || true
    rm -f /run/uuidd/request || true
    rm -rf /tmp/*
    rm -f /var/crash/*
    rm -f /var/lib/urandom/random-seed
    find /var/log -type f -name '*.gz' -delete
    find /var/log -type f -name '*.1' -delete
    find /var/log -type f -name '*.old' -delete

    # Copy configuration files
    cp /etc/stellarmate/environment /etc/environment
    cp /etc/stellarmate/rules/60-gpsd.rules /lib/udev/rules.d/
    cp /etc/stellarmate/smb.conf /etc/samba/

    # Reset timezone to UTC
    timedatectl set-timezone UTC

    rm -rf /lib/modules.bak || true
    rm -rf /home/stellarmate/.bash_history

    # Clean user directories
    echo "Removing pictures and downloads..."
    rm -rf /home/stellarmate/Pictures/*
    rm -rf /home/stellarmate/Documents/*
    rm -rf /home/stellarmate/Downloads/*

    # Clear EkosLive
    rm -rf /home/stellarmate/.local/share/ekoslive/*
    cp /etc/stellarmate/ekoslive.db /home/stellarmate/.local/share/ekoslive/

    # Set NetworkManager ownership
    chown -R root:root /etc/NetworkManager

    # Clean package manager cache
    if [ "$OS_TYPE" == "debian_ubuntu" ]; then
        apt-get clean
    elif [ "$OS_TYPE" == "arch" ]; then
        pacman -Sc
    fi

    # Reset wallet
    echo "Clearing wallet..."
    /etc/stellarmate/reset-wallet.sh

    # Clear logs
    echo "Clearing logs..."
    rm -rf ~/.local/share/recently-user.xbel
    journalctl --vacuum-size=1M

    # Reset RustDesk
    runuser -l stellarmate -c 'DISPLAY=:0 rustdesk &'
    sleep 2
    rustdesk --password stellar@Mate123!
    pkill rustdesk

    # Disable RustDesk
    systemctl stop rustdesk
    systemctl disable rustdesk

    # Clear machine ID
    truncate -s 0 /etc/machine-id /var/lib/dbus/machine-id

    # Set final ownership
    chown -R stellarmate:stellarmate /home/stellarmate
}
