#!/usr/bin/python3

import os
import subprocess
import logging
import time

skip_list=["indi_eval", "indi_getprop", "indi_setprop", "indi_hid_test"]

logging.basicConfig(format='%(asctime)s - %(levelname)s: %(message)s', level=logging.INFO)

os.system("pkill indiserver")
for file in os.listdir("/usr/bin"):
    if file.startswith("indi_") and file not in skip_list:
        try:
            logging.info("------------------------------------------------------------------------------------------")
            os.system("pkill indiserver")
            time.sleep(2)
            command = "indiserver -r 0 -v /usr/bin/" + file
            output = subprocess.check_output(command, shell=True, timeout=2).decode("utf-8")
            if "Terminated" in output:
                logging.error("Driver failed: " + file)
        except subprocess.CalledProcessError as error:
            logging.error("Driver failed: " + file)
            exit(-1)
        except subprocess.TimeoutExpired:
            logging.info("%s Finished successfully" % file)
