#!/bin/bash

# Change hostname to supplied hostname

json_result=true
json_message=""

output_json_and_exit() {
    echo "{\"result\": $json_result, \"message\": \"$json_message\"}"
    exit 0
}

desiredHostname="stellarmate"

# If argument is passed, use it as hostname
if [ $# -eq 1 ]; then
desiredHostname=$1
fi

if [ $HOSTNAME == $desiredHostname ]; then
    json_message="No change in hostname"
    output_json_and_exit
fi

echo "Changing current"  $HOSTNAME "to" $desiredHostname

echo $desiredHostname > /etc/hostname
if [ $? -ne 0 ]; then
    json_result=false
    json_message="Failed to write hostname to /etc/hostname."
    output_json_and_exit
fi

# We need to change NM system connection file
nm_source_file="/etc/NetworkManager/system-connections/$HOSTNAME"
nm_fallback_file="/etc/NetworkManager/system-connections/stellarmate"
nm_target_file="/etc/NetworkManager/system-connections/$desiredHostname"

if [ -f "$nm_source_file" ]; then
    echo "NetworkManager connection file found: $nm_source_file"
    mv "$nm_source_file" "$nm_target_file"
    if [ $? -ne 0 ]; then
        json_result=false
        json_message+="Failed to move NetworkManager file from $nm_source_file. "
    fi
    chmod 600 /etc/NetworkManager/system-connections/*
    # Update id and ssid fields specifically
    sed -i "s/^id=.*/id=$desiredHostname/g" "$nm_target_file"
    if [ $? -ne 0 ]; then
        json_result=false
        json_message+="Failed to update id in NetworkManager file $nm_target_file. "
    fi
    sed -i "s/^ssid=.*/ssid=$desiredHostname/g" "$nm_target_file"
    if [ $? -ne 0 ]; then
        json_result=false
        json_message+="Failed to update ssid in NetworkManager file $nm_target_file. "
    fi
elif [ -f "$nm_fallback_file" ]; then
    echo "NetworkManager connection file not found for $HOSTNAME, using fallback: $nm_fallback_file"
    mv "$nm_fallback_file" "$nm_target_file"
    if [ $? -ne 0 ]; then
        json_result=false
        json_message+="Failed to move NetworkManager fallback file from $nm_fallback_file. "
    fi
    chmod 600 /etc/NetworkManager/system-connections/*
    # Update id and ssid fields specifically
    sed -i "s/^id=.*/id=$desiredHostname/g" "$nm_target_file"
    if [ $? -ne 0 ]; then
        json_result=false
        json_message+="Failed to update id in NetworkManager fallback file $nm_target_file. "
    fi
    sed -i "s/^ssid=.*/ssid=$desiredHostname/g" "$nm_target_file"
    if [ $? -ne 0 ]; then
        json_result=false
        json_message+="Failed to update ssid in NetworkManager fallback file $nm_target_file. "
    fi
else
    json_result=false
    json_message+="Neither NetworkManager connection file for $HOSTNAME nor stellarmate found. Skipping NetworkManager file modification. "
fi

# Update /etc/hosts
sed -i "s/\b$HOSTNAME\b/$desiredHostname/g" "/etc/hosts"
if [ $? -ne 0 ]; then
    json_result=false
    json_message+="Failed to update hostname in /etc/hosts. "
fi

# Remove Google Chrome Singleton files if installed
if which google-chrome-stable >/dev/null; then
    echo "google-chrome-stable detected. Removing Singleton files."
    rm -rf /home/stellarmate/.config/google-chrome/Singleton*
    if [ $? -ne 0 ]; then
        json_result=false
        json_message+="Failed to remove Google Chrome Singleton files. "
    fi
fi

output_json_and_exit
