// Startup function

let SPAStage;
$(function () {
    $('#sm-assistant-info-button').popover(
        {
            trigger: 'manual',
            placement: 'right',
            html: true,
            title: "Serial Port Assistant",
            content: function () {
                var listHTML = "<p><strong>Serial Port Assistant</strong> ensures that your serial devices designations are saved permenantly." +
                    " When you plug your mount, it is assigned a random port (e.g. <i>COM2</i> or <i>/dev/ttyUSB1</i>). This port is required in order" +
                    " for INDI to communicate with your mount. Using the assistant, you can assign a permenant ID to your mount (e.g. <i>/dev/mount</i>)," +
                    " and any device that uses Serial-To-USB adapters.</p>";

                return listHTML;
            }
        });

    $('#sm-assistant-hardware-button').popover(
        {
            trigger: 'manual',
            placement: 'right',
            html: true,
            title: "Hardware Based Mapping",
            content: function () {
                const listHTML = "<p>If you plug your equipment <strong>always</strong> at the same physical USB slots, then checking this option will bind the port"+
                               " to this specific slot. This is useful if you have two or more <i>identical</i> Serial-To-USB adapters and the only way to distinguish between"+
                               " them is by plugging them to different USB ports";

                return listHTML;
            }
        });

        $('#sm-bluetooth-hardware-button').popover(
        {
            trigger: 'manual',
            placement: 'right',
            html: true,
            title: "Bluetooth Devices Wizard",
            content: function () {
                const listHTML = "<p>If you have a <strong>Bluetooth device</strong>, toggle this checkbox to go to the"+
                               " Bluetooth devices wizard. The Bluetooth devices wizard allows you to scan, pair and bind new devices, or bind already paired devices.";

                return listHTML;
            }
        });

    loadRules();
    loadSPAStage();

});

function loadRules() {
    $("tbody").empty();

    $.getJSON("/api/udev/rules", function (rules) {
        if (Object.keys(rules).length === 0) {
            $("#mappings-message").show();
            $("#mappings-table").hide();
            localStorage.setItem("rules", "[]");
        }
        else {
            $("#mappings-message").hide();
            localStorage.setItem("rules", JSON.stringify(rules));
            let body = "";

            $.each(rules, function (i, field) {
                body = "<tr>";
                body += "<td>/dev/" + field.symlink + ((field.port === "--") ? "</td>" : "<span class=\"fas fa-thumbtack fa-fw\"></span></td>");
                body += "<td>0x" + field.vid + "</td><td>0x" + field.pid + "</td><td>" + field.serial + "</td>";
                body += "<td><button onClick=\"removeRule(" + i + ")\" type=\"button\" class=\"btn btn-info\"><span class=\"fas fa-minus-circle fa-fw\"></span></button></td>"
                body += "</tr>";
                $("tbody").append(body);
            });

            $("#mappings-table").show();
        }
    });
}


function removeRule(index) {

    bootbox.confirm({
        message: "Are you sure you want to delete the mapping?",
        buttons: {
            confirm: {
                label: 'Yes',
                className: 'btn-success'
            },
            cancel: {
                label: 'No',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                let rules = JSON.parse(localStorage.getItem("rules"));
                let oneRule = rules[index];
                console.log("Removing rule " + JSON.stringify(oneRule));

                $.ajax({
                    url: '/api/udev/remove_rule',
                    type: 'POST',
                    contentType: "application/json; charset=utf-8",
                    data: JSON.stringify(oneRule),
                    success: function (response) {
                        loadRules();
                    }
                });
            }
        }
    });
}

function loadSPAStage() {
    SPAStage = localStorage.getItem("SPAStage");
    if (SPAStage == null)
        SPAStage = "Idle";

    console.log("SPA Stage is: " + SPAStage);

    displaySPAStage();
}

function displaySPAStage() {
    $("#idle-stage").hide();
    $("#select-stage").hide();
    $("#connect-stage").hide();
    $("#bt-connect-stage").hide();
    $("#detect-stage").hide();
    $("#bt-detect-stage").hide();
    $("#fail-stage").hide();
    $("#bt-paired-stage").hide();

    switch (SPAStage) {
        case "Idle":
            $("#idle-stage").show();
            break;

        case "Select":
            $("#select-stage").show();
            break;

        case "BtPaired":
            $("#bt-paired-stage").show();
            break;

        case "Connect":
            if ($('input[name=hardware_bluetooth]:checked').length > 0)
                $("#bt-connect-stage").show();
            else
                $("#connect-stage").show();
            break;

        case "Detect":
            if ($('input[name=hardware_bluetooth]:checked').length > 0)
                $("#bt-detect-stage").show();
            else
                $("#detect-stage").show();
            break;

        case "Fail":
            $("#fail-stage").show();
            break;
    }
}

function goNextStage() {
    switch (SPAStage) {
        case "Idle":
            SPAStage = "Select";
            break;

        case "Select":
            SPAStage = "Connect";
            var deviceType = $("input:radio[name=devtype]:checked").val();
            var otherType = $("input:text[name=othertype]").val();
            console.log("Other type text: " + otherType);
            if (deviceType == "other" && otherType)
                deviceType = otherType.replace(/\s/g, '');

            localStorage.setItem("deviceType", deviceType);
            console.log("Selected device type: " + deviceType);
            if ($('input[name=hardware_bluetooth]:checked').length > 0){
            SPAStage = "BtPaired";
            displaySPAStage();
//                bluetoothDevices();
            pairedBluetoothDevices();
            }
            else
                watchDevices();
            break;

        case "Connect":

            break;

        case "Detect":
            SPAStage = "BtPair";
            break;

        case "BtPaired":
            SPAStage = "Connect";
            bluetoothDevices();
            break;

        case "Fail":

            break;
    }

    displaySPAStage();
}

function restartStage() {
    SPAStage = "Idle";
    displaySPAStage();
}

function watchDevices() {
    $.getJSON("/api/udev/watch", function (device) {
        if (Object.keys(device).length === 0) {
            SPAStage = "Idle";
            displaySPAStage();
            $("<div title='Timed out'><p>Failed to detect any new devices. Please make sure device is powered and connected to StellarMate via USB.</p>" +
                "<p>Please disconnect all devices and try again.</p></div>").dialog();
        }
        else {
            console.log("Devices:\n" + JSON.stringify(device));
            let Exp = /^[0-9a-zA-Z-]+$/;
            let serial = "--";
            if (device['ID_SERIAL'].match(Exp))
                serial = device['ID_SERIAL'];

            let deviceType = localStorage.getItem("deviceType");

            let oneRule = {
                'vid': device['ID_VENDOR_ID'],
                'pid': device['ID_MODEL_ID'],
                'serial': serial,
                'symlink': deviceType
            };

            let hardwarePortChecked = $('input[name=hardware_usb]:checked').length > 0;
            let rules = JSON.parse(localStorage.getItem("rules"));
            let duplicateDetected = false;

            if (hardwarePortChecked)
            {
                let index = device['DEVPATH'].lastIndexOf('/');
                //var port;
                if (index > 0)
                    oneRule['port'] = device['DEVPATH'].substring(index+1);
            }
            else
            {
                rules.forEach( function(rule)
                {
                    if (rule.pid === oneRule.pid && rule.vid === oneRule.vid && rule.serial === oneRule.serial && rule.symlink !== oneRule.symlink)
                    {
                        duplicateDetected = true;
                    }
                });
            }

            $.ajax({
                url: '/api/udev/add_rule',
                type: 'POST',
                contentType: "application/json; charset=utf-8",
                data: JSON.stringify(oneRule),
                success: function (response)
                {
                    loadRules();
                    if (duplicateDetected)
                        bootbox.alert("Warning! Duplicate device detected. You must remove one mapping or enable hardware slot mapping.");
                    else
                        $("<div title='Success'><p>Mapping is successful. Please unplug and replug your device now. Use the indicated Port <strong>/dev/" + deviceType + "</strong> when connecting to your device in INDI.</p></div>").dialog();
                    SPAStage = "Idle";
                    displaySPAStage();
                }
            });
        }
    });
}

function pairedBluetoothDevices() {
    $.getJSON("/api/udev/bt/paired", function (data) {
        if (Object.keys(data).length === 0) {
                SPAStage = "Idle";
                displaySPAStage();
                $("<div title='Timed out'><p>Failed to detect any new devices. Please make sure device is powered and connected to StellarMate via USB.</p>" +
                    "<p>Please disconnect all devices and try again.</p></div>").dialog();
            }
            else {
                console.log("Devices:\n" + JSON.stringify(data));
                $("#mappings-message").hide();
//                var dev_arr = [];
//                for(var item in data.devices) {
//                    dev_arr.push(data.devices[item].name);
                 }

//                console.log(dev_arr);
//                localStorage.setItem("rules", JSON.stringify(rules));
//                localStorage.setItem("bt-devices", JSON.stringify(data));
                $("#bt-pdevices-table tbody").empty();
                let body = "";
                $.each(data.paired_devices, function (i, device) {
                    console.log(body);
                    body = "<tr>";
                    body += "<td>" + device.name + "</td>";
                    body += "<td>" + device.mac_address + "</td>";
                    body += "<td><button onClick='bluetoothBind(\"" + device.mac_address + "\")' type=\"button\" class=\"btn btn-info\"><span class=\"fas fa-arrow-circle-right fa-fw\"></span></button></td>"
//                    body += "<td>0x" + field.vid + "</td><td>0x" + field.pid + "</td><td>" + field.serial + "</td>";
//                    body += "<td><button onClick=\"removeRule(" + i + ")\" type=\"button\" class=\"btn btn-info\"><span class=\"fas fa-minus-circle fa-fw\"></span></button></td>"
                    body += "</tr>";
                    $("#bt-pdevices-table tbody").append(body);
//                    console.log($("#bt-devices-table tbody").append(body))
                });
//                $("#bt-devices-table tbody").append(body);
                console.log(body);
                $("#bt-pdevices-table").show();
//                $("#bt-detect-stage").show();
//                SPAStage = "Detect";
//                displaySPAStage();
    });
}

function bluetoothDevices() {
    SPAStage = "Connect";
    displaySPAStage();
    $.getJSON("/api/udev/bt/scan", function (data) {
        if (Object.keys(data).length === 0) {
                SPAStage = "Idle";
                displaySPAStage();
                $("<div title='Timed out'><p>Failed to detect any new devices. Please make sure device is powered and connected to StellarMate via USB.</p>" +
                    "<p>Please disconnect all devices and try again.</p></div>").dialog();
            }
            else {
                console.log("Devices:\n" + JSON.stringify(data));
                $("#mappings-message").hide();
//                var dev_arr = [];
//                for(var item in data.devices) {
//                    dev_arr.push(data.devices[item].name);
                 }

//                console.log(dev_arr);
//                localStorage.setItem("rules", JSON.stringify(rules));
//                localStorage.setItem("bt-devices", JSON.stringify(data));
                $("#bt-devices-table tbody").empty();
                let body = "";
                $.each(data.devices, function (i, device) {
                    console.log(body);
                    body = "<tr>";
                    body += "<td>" + device.name + "</td>";
                    body += "<td>" + device.mac_address + "</td>";
                    pid = "pincode" + i;
                    body += "<td>" + "<input type=\"text\" id=\""+pid+"\" placeholder=\"Enter pin\">" + "</td>";
                    body += "<td><button onClick='bluetoothPair(\"" + device.mac_address + "\", \""+pid+"\")' type=\"button\" class=\"btn btn-info\"><span class=\"fas fa-arrow-circle-right fa-fw\"></span></button></td>"
//                    body += "<td>0x" + field.vid + "</td><td>0x" + field.pid + "</td><td>" + field.serial + "</td>";
//                    body += "<td><button onClick=\"removeRule(" + i + ")\" type=\"button\" class=\"btn btn-info\"><span class=\"fas fa-minus-circle fa-fw\"></span></button></td>"
                    body += "</tr>";
                    $("#bt-devices-table tbody").append(body);
//                    console.log($("#bt-devices-table tbody").append(body))
                });
//                $("#bt-devices-table tbody").append(body);
                console.log(body);
                $("#bt-devices-table").show();
//                $("#bt-detect-stage").show();
                SPAStage = "Detect";
                displaySPAStage();
    });
}
function bluetoothPair(mac_address, pincode){
object = {"mac_address": mac_address, "pin": document.getElementById(pincode).value};
$.ajax("/api/udev/bt/pair", {
    data : JSON.stringify(object),
    contentType : 'application/json',
    type : 'POST',
    success: function (data) {

    var response = JSON.parse(data);

        if (response.result === "successful"){
            bluetoothBind(mac_address);
            }
        else
            alert("Failed pairing and binding bluetooth device!");

         }
    });
//$.post("/api/udev/bt/pair", object, function (data) {
//        if (Object.keys(data).length === 0) {
//                SPAStage = "Idle";
//                displaySPAStage();
//                $("<div title='Timed out'><p>Failed to detect any new devices. Please make sure device is powered and connected to StellarMate via USB.</p>" +
//                    "<p>Please disconnect all devices and try again.</p></div>").dialog();
//            }
//            else {
//                console.log("Devices:\n" + JSON.stringify(data));
//                }
//                }, 'json');
}

function bluetoothBind(mac_address){
object = {"mac_address": mac_address};
$.ajax("/api/udev/bt/bind", {
    data : JSON.stringify(object),
    contentType : 'application/json',
    type : 'POST',
    success: function (data) {
        var response = JSON.parse(data);

        if (response.result === "successful"){
            alert("Successfully paired and binded bluetooth device!");
            SPAStage = "Idle";
            displaySPAStage();
            }
        else
            alert("Failed pairing and binding bluetooth device!");
                    }
    });
}

function bluetoothUnbind(){
$.ajax("/api/udev/bt/unbind", {
    contentType : 'application/json',
    type : 'GET',
    success: function (data) {

        alert("Unbinded bluetooth device!");

                    }
    });
}