#!/bin/bash

# Source common reset functions
source /etc/stellarmate/reset-factory-common.sh

# Additional cleanup specific to SM-150
rm -rf /etc/stellarmate/8gb || true

# Perform common reset operations with imatepro hostname
perform_common_reset "imatepro"

cp /etc/stellarmate/kstars/config/* /home/stellarmate/.config
cp /etc/stellarmate/kstars/catalogs/* /home/stellarmate/.local/share/kstars

# SM-150 specific operations
# Set plymouth theme
plymouth-set-default-theme stellarmate-logo

# Reset boot to default settings
echo "Resetting boot to default..."
cp /etc/stellarmate/boot/* /boot/

# Clean up Raspberry Pi specific files
rm -f /boot/.firmware_revision || true
rm -rf /boot.bak || true

# Clean apt cache and remove RPi specific packages
apt-get -y purge rpi.gpio-common modemmanager

# Enable filesystem resize service
echo "Enabling resize file system service..."
systemctl enable resize-fs.service

echo "Reset complete. iMatePro must be restarted now."
