#!/bin/bash

# Source common reset functions
source /etc/stellarmate/reset-factory-common.sh

# Additional cleanup specific to SM-140
rm -rf /etc/stellarmate/8gb || true

# Perform common reset operations with stellarmate hostname
perform_common_reset "stellarmate"

cp /etc/stellarmate/kstars/config/* /home/stellarmate/.config
cp /etc/stellarmate/kstars/catalogs/* /home/stellarmate/.local/share/kstars

# SM-140 specific operations
# Set plymouth theme
plymouth-set-default-theme stellarmate-logo

# Reset boot to default settings
echo "Resetting boot to default..."
cp -r /etc/stellarmate/boot/* /boot/

# Clean up Raspberry Pi specific files
rm -f /boot/.firmware_revision || true
rm -rf /boot.bak || true

# Clean apt cache and remove RPi specific packages
apt-get -y purge rpi.gpio-common modemmanager

echo "Setting StellarMate logo for Main Menu..."
cp /etc/stellarmate/icon.png /usr/share/icons/PiXflat/48x48/places/start-here.png
cp /etc/stellarmate/icon.png /usr/share/icons/PiXflat/32x32/places/start-here.png
gtk-update-icon-cache -f /usr/share/icons/PiXflat

# Enable filesystem resize service
echo "Enabling resize file system service..."
systemctl enable resize-fs.service

echo "Reset complete. StellarMate must be restarted now."
